/***************************************************************************
 *
 * Copyright (C) 2001 International Business Machines
 * All rights reserved.
 *
 * This file is part of the GPFS mmfslinux kernel module.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer. 
 *  2. Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution. 
 *  3. The name of the author may not be used to endorse or promote products 
 *     derived from this software without specific prior written
 *     permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *************************************************************************** */
/* $Id: block.c,v 1.18.2.1 2002/05/21 21:44:58 dcraft Exp $
 *
 * $Log: block.c,v $
 * Revision 1.18.2.1  2002/05/21 21:44:58  dcraft
 * Pull GPFS 1.2.1 up to kernel 2.4.18.
 * mmfsfuncs.Linux must be distributed with /usr/lpp/mmfs/src
 * on developerworks.
 *
 * Revision 1.18  2001/09/25 18:05:34  gjertsen
 * Remove obsolete IA64 hack.
 *
 * Revision 1.17  2001/05/04 23:30:11  schmuck
 * Move "extern struct xxx_operations ..." declarations into .h file
 * instead of replicating them in various .c files.
 * Replace empty gpfs_dops_valid table with a NULL pointer.
 *
 * Revision 1.16  2001/04/25 14:43:15  dixonbp
 * Choose filesystem major number dynamically.
 *
 * Revision 1.15  2001/04/19 20:48:59  wyllie
 * Take fields out of struct ss_struct that do not need to be there.
 *
 * Revision 1.14  2001/03/29 21:32:51  dixonbp
 * Convert block,dir, and lxtrace to .c files
 *
 * Revision 1.9  2000/12/18 13:53:12  gjertsen
 * More cleanup of comments/documentation.
 *
 * Revision 1.8  2000/12/15 13:56:32  gjertsen
 * Clean up documentation.
 *
 */

#define __NO_VERSION__

#ifndef __KERNEL__
#define __KERNEL__
#endif

#include <Shark-gpl.h>

#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/stat.h>
#include <linux/errno.h>
#include <linux/module.h>

#include <linux/devfs_fs_kernel.h>

#include <cxiTypes.h>
#include <cxiSharedSeg.h>
#include <cxiSystem.h>
#include <linux2gpfs.h>
#include <Trace.h>


/* Major number for GPFS filesystem /dev entries.  Note that FS_MAJOR
   is just our first choice for a number.  Since we don't have a reserved
   number (see linux/major.h) we have to be prepared to receive EBUSY when
   we register.  If FS_MAJOR is already taken, we allow devfs_register_blkdev
   to assign us any available number.  After we've registered, our major
   number will be stored in GPFSFileSysMajorNumber.  */
#define FS_MAJOR 239
int GPFSFileSysMajorNumber;


ssize_t 
gpfs_fb_read(struct file *file, char *buf, size_t nbytes, loff_t *ppos)
{
  TRACE1(TRACE_BOPS, 2, TRCID_FILE_001,
         "gpfs_fb_read: called 0x%08X\n", nbytes);
  return 0; /* number of bytes used in the buffer */
}

ssize_t 
gpfs_fb_write(struct file *file, const char *buf, size_t nbytes, loff_t *ppos)
{
  TRACE1(TRACE_BOPS, 2, TRCID_FILE_003,
         "gpfs_fb_write: called 0x%08X\n", nbytes);
  return 0;
}

int 
gpfs_fb_open(struct inode *inode, struct file *file)
{
  TRACE0(TRACE_BOPS, 2, TRCID_FILE_005, "gpfs_fb_open: called\n");
  return 0;          /* success */
}

int 
gpfs_fb_release(struct inode *inode, struct file *file)
{
  struct block_device *bdP;
  int count;

  TRACE1(TRACE_BOPS, 2, TRCID_FILE_071,
         "gpfs_fb_release: inode 0x%X\n", inode);

  if (inode->i_bdev)
  {
    bdP = inode->i_bdev;
# if LINUX_KERNEL_VERSION >= 2041300
    count = bdP->bd_openers;
#else
    count = atomic_read(&bdP->bd_openers);
#endif
    if (count > 0)
      /*
       * Immunize device against invalidate_buffers() and prune_icache().
       */
# if LINUX_KERNEL_VERSION >= 2041300
    count = bdP->bd_openers;
#else
      atomic_dec(&bdP->bd_openers);
#endif
    TRACE2(TRACE_BOPS, 2, TRCID_FILE_0712,
           "gpfs_fb_release: bdP 0x%lX count %d\n", bdP, count);
  }
  return 0;          /* success */
}

int 
gpfs_fb_ioctl(struct inode *inode, struct file *file, unsigned p1, 
              unsigned long p2)
{
  TRACE0(TRACE_BOPS, 2, TRCID_FILE_072, "gpfs_fb_ioctl: called\n");
  return 0;          /* success */
}

int
gpfs_b_open(struct inode *inode, struct file *file)
{
  struct block_device *bdP;
  int count;

  TRACE1(TRACE_BOPS, 2, TRCID_BLOCK_005, "gpfs_b_open: inode 0x%X\n", inode);
  if (!inode)
          return -EINVAL;

  if (inode->i_bdev)
  {
    bdP = inode->i_bdev;
# if LINUX_KERNEL_VERSION >= 2041300
    count = bdP->bd_openers;
#else
    count = atomic_read(&bdP->bd_openers);
#endif
    TRACE2(TRACE_BOPS, 2, TRCID_BLOCK_0051,
           "gpfs_b_open: bdP 0x%lX count %d\n", bdP, count);
    /*
     * Immunize device against invalidate_buffers() and prune_icache().
     */
  }
  file->f_op = &gpfs_fbps;

  return 0;          /* success */
}

int 
gpfs_b_release(struct inode *inode, struct file *file)
{
  struct block_device *bdP;
  int count;

  TRACE1(TRACE_BOPS, 2, TRCID_BLOCK_071,
         "gpfs_b_release: inode 0x%X\n", inode);

  if (inode->i_bdev)
  {
    bdP = inode->i_bdev;
# if LINUX_KERNEL_VERSION >= 2041300
    count = bdP->bd_openers;
#else
    count = atomic_read(&bdP->bd_openers);
#endif
    TRACE2(TRACE_BOPS, 2, TRCID_BLOCK_0712,
           "gpfs_b_release: bdP 0x%lX count %d\n", bdP, count);
  }
  return 0;          /* success */
}

int 
gpfs_b_ioctl(struct inode *inode, struct file *file, unsigned p1,
             unsigned long p2)
{
  TRACE0(TRACE_BOPS, 2, TRCID_BLOCK_072, "gpfs_b_ioctl: called\n");
  return 0;          /* success */
}

int 
gpfs_b_check_media_change(kdev_t dev)
{
  TRACE0(TRACE_BOPS, 2, TRCID_BLOCK_073, "gpfs_b_check_media_change: called\n");
  return 0;          /* success */
}

int 
gpfs_b_revalidate(kdev_t dev)
{
  TRACE0(TRACE_BOPS, 2, TRCID_BLOCK_074, "gpfs_b_revalidate: called\n");
  return 0;          /* success */
}

int 
gpfs_block_init()
{
  int rc;

  GPFSFileSysMajorNumber = FS_MAJOR;

retry:
  rc = devfs_register_blkdev(GPFSFileSysMajorNumber, "gpfs", &gpfs_bops);
  if (rc < 0)
  {
    TRACE2(TRACE_BOPS, 2, TRCID_BLOCK_011,
           "gpfs_block_init: unable to get major %d rc %d\n",
           GPFSFileSysMajorNumber, rc);

    /* If FS_MAJOR was already taken, register without specifying a major
       number (allow devfs_register_blkdev to choose an available one). */

    if ((rc == -EBUSY) && (GPFSFileSysMajorNumber == FS_MAJOR))
    {
      GPFSFileSysMajorNumber = 0;
      goto retry;
    }

    GPFSFileSysMajorNumber = 0;
    return -1;
  }

  /* If devfs_register_blkdev chose the number, save it so we can
     properly unregister later. */

  if (GPFSFileSysMajorNumber == 0)
    GPFSFileSysMajorNumber = rc;

  TRACE2(TRACE_BOPS, 2, TRCID_BLOCK_013,
         "gpfs_block_init: register_blkdev %d rc %d\n",
         GPFSFileSysMajorNumber, rc);
  return 0;
}

void 
gpfs_block_clean()
{
  int rc;

  rc = unregister_blkdev(GPFSFileSysMajorNumber, "gpfs");
  TRACE2(TRACE_BOPS, 2, TRCID_BLOCK_015,
         "gpfs_block_clean: unregister_blkdev %d rc %d\n",
         GPFSFileSysMajorNumber, rc);
  GPFSFileSysMajorNumber = 0;
}
